package cn.datax.system;

import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataAuthExceptionHandler;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

@EnableDiscoveryClient
@EnableCircuitBreaker
@EnableDataAuthExceptionHandler
@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableFeignClients
@SpringBootApplication
public class DataSystemApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataSystemApplication.class);
    }

}
