package cn.datax.common.database;

import cn.datax.common.database.core.DbColumn;
import cn.datax.common.database.core.PageResult;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * 表数据查询接口
 *
 * @author yuwei
 * @since 2020-03-14
 */
public interface DbQuery {

    /**
     * 检测连通性
     */
    boolean valid() throws SQLException;

    /**
     * 关闭数据源
     */
    void close();

    /**
     *  获取指定表 具有的所有字段列表
     * @param dbName
     * @param tableName
     * @return
     */
    List<DbColumn> getTableColumns(String dbName, String tableName);

    /**
     * 获取指定数据库下 所有的表信息
     *
     * @param dbName
     * @return
     */
    List<String> getTables(String dbName);

    /**
     * 获取总数
     *
     * @param sql
     * @return
     */
    int count(String sql);

    /**
     * 查询结果列表
     *
     * @param sql
     * @return
     */
    List<Map<String, Object>> queryList(String sql);

    /**
     * 查询结果分页
     *
     * @param sql
     * @param offset
     * @param size
     * @return
     */
    PageResult<Map<String, Object>> queryByPage(String sql, long offset, long size);
}
