package cn.datax.service.data.metadata.api.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 元数据变更记录表 实体VO
 * </p>
 *
 * @author yuwei
 * @since 2020-07-30
 */
@Data
public class MetadataChangeRecordVo implements Serializable {

    private static final long serialVersionUID=1L;

    private String id;
    private Integer status;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private Integer version;
    private String objectType;
    private String objectId;
    private String fieldName;
    private String fieldOldValue;
    private String fieldNewValue;
}
