package cn.datax.service.data.market.api.mapping.config;

import cn.datax.common.rabbitmq.config.RabbitMqConstant;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.data.market.api.entity.DataApiEntity;
import cn.datax.service.data.market.api.feign.DataApiServiceFeign;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class RabbitMqListenerConfig {

    @Autowired
    private DataApiServiceFeign dataApiServiceFeign;

    @Autowired
    private MappingHandlerMapping mappingHandlerMapping;

    @Autowired
    private ObjectMapper objectMapper;

    /**
     * Fanout 交换机
     * 消费注册
     */
    @RabbitListener(bindings = @QueueBinding(exchange = @Exchange(name = RabbitMqConstant.FANOUT_EXCHANGE_API_RELEASE_NAME, type = "fanout", durable = "true", autoDelete = "false"),
            value = @Queue(value = RabbitMqConstant.FANOUT_EXCHANGE_QUEUE_TOPIC_API_RELEASE1, durable = "true", exclusive = "false", autoDelete = "false")))
    public void fanoutQueueRelease(String id, Channel channel, Message message) throws Exception {
        try {
            System.out.println("fanoutQueueRelease接收到了：" + id);
            DataApiEntity dataApiEntity = dataApiServiceFeign.getDataApiById(id);
            if(dataApiEntity != null){
                log.info("api={}", dataApiEntity);
            }
        }catch (Exception e){
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
        }
    }

    /**
     * Fanout 交换机
     * 消费注销
     */
    @RabbitListener(bindings = @QueueBinding(exchange = @Exchange(name = RabbitMqConstant.FANOUT_EXCHANGE_API_CANCEL_NAME, type = "fanout", durable = "true", autoDelete = "false"),
            value = @Queue(value = RabbitMqConstant.FANOUT_EXCHANGE_QUEUE_TOPIC_API_CANCEL1, durable = "true", exclusive = "false", autoDelete = "false")))
    public void fanoutQueueCancel(String id, Channel channel, Message message) throws Exception {
        try {
            System.out.println("fanoutQueueCancel接收到了：" + id);
        }catch (Exception e){
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
        }
    }
}
