package cn.datax.service.email.api.feign;

import cn.datax.common.core.R;
import cn.datax.service.email.api.dto.EmailDto;
import cn.datax.service.email.api.entity.EmailEntity;
import cn.datax.service.email.api.feign.factory.EmailServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(contextId = "emailServiceFeign", value = "datax-service-email", fallbackFactory = EmailServiceFeignFallbackFactory.class)
public interface EmailServiceFeign {

    @PostMapping("/inner/sendMail")
    R sendMail(@RequestBody EmailDto mail);

}
