import request from '@/utils/request'

export function listDataTheme (data) {
  return request({
    url: '/data/factory/dataThemes/list',
    method: 'get',
    params: data
  })
}

export function pageDataTheme (data) {
  return request({
    url: '/data/factory/dataThemes/page',
    method: 'get',
    params: data
  })
}

export function getDataTheme (id) {
  return request({
    url: '/data/factory/dataThemes/' + id,
    method: 'get'
  })
}

export function delDataTheme (id) {
  return request({
    url: '/data/factory/dataThemes/' + id,
    method: 'delete'
  })
}

export function delDataThemes (ids) {
  return request({
    url: '/data/factory/dataThemes/batch/' + ids,
    method: 'delete'
  })
}

export function addDataTheme (data) {
  return request({
    url: '/data/factory/dataThemes',
    method: 'post',
    data: data
  })
}

export function updateDataTheme (data) {
  return request({
    url: '/data/factory/dataThemes/' + data.id,
    method: 'put',
    data: data
  })
}
