package cn.datax.service.email.service.impl;

import cn.datax.service.email.api.entity.EmailEntity;
import cn.datax.service.email.service.EmailService;
import cn.datax.service.email.utils.EmailUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class EmailServiceImpl implements EmailService {

    @Autowired
    private EmailUtil emailUtil;

    @Override
    public void sendEmail(EmailEntity emailEntity) {
        log.info("实体类 {}", emailEntity);
        try {
            emailUtil.sendEmail(emailEntity);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
