package cn.datax.service.data.market.api.call.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.database.core.PageResult;
import cn.datax.service.data.market.api.call.service.ApiCallService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@RequestMapping("/v1")
public class ApiCallController extends BaseController {

    @Autowired
    private ApiCallService apiCallService;

    @RequestMapping(value = "/**", method = {RequestMethod.GET, RequestMethod.POST})
    public R apiCall(){
        PageResult<Map<String, Object>> pageResult = apiCallService.apiCall();
        return R.ok().setData(pageResult);
    }
}
