package cn.datax.service.data.market.api.call.service.impl;

import cn.datax.common.utils.MD5Util;
import cn.datax.common.utils.SecurityUtil;
import cn.datax.service.data.market.api.call.service.ApiHeaderService;
import cn.datax.service.data.market.api.vo.ApiHeader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ApiHeaderServiceImpl implements ApiHeaderService {

    @Override
    public ApiHeader getApiHeader(String id) {
        ApiHeader apiHeader = new ApiHeader();
        try {
            MD5Util mt = MD5Util.getInstance();
            apiHeader.setApiKey(mt.encode(id));
            apiHeader.setSecretKey(mt.encode(SecurityUtil.getUserId()));
        } catch (Exception e) {
        }
        return apiHeader;
    }
}
