package cn.datax.service.data.metadata.service.impl;

import cn.datax.common.core.DataConstant;
import cn.datax.service.data.metadata.api.dto.MetadataColumnDto;
import cn.datax.service.data.metadata.api.entity.MetadataColumnEntity;
import cn.datax.service.data.metadata.api.entity.MetadataSourceEntity;
import cn.datax.service.data.metadata.api.entity.MetadataTableEntity;
import cn.datax.service.data.metadata.api.enums.DataLevel;
import cn.datax.service.data.metadata.api.vo.MetadataTreeVo;
import cn.datax.service.data.metadata.dao.MetadataSourceDao;
import cn.datax.service.data.metadata.dao.MetadataTableDao;
import cn.datax.service.data.metadata.service.MetadataColumnService;
import cn.datax.service.data.metadata.mapstruct.MetadataColumnMapper;
import cn.datax.service.data.metadata.dao.MetadataColumnDao;
import cn.datax.common.base.BaseServiceImpl;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 元数据信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-07-29
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class MetadataColumnServiceImpl extends BaseServiceImpl<MetadataColumnDao, MetadataColumnEntity> implements MetadataColumnService {

    @Autowired
    private MetadataSourceDao metadataSourceDao;

    @Autowired
    private MetadataTableDao metadataTableDao;

    @Autowired
    private MetadataColumnDao metadataColumnDao;

    @Autowired
    private MetadataColumnMapper metadataColumnMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MetadataColumnEntity saveMetadataColumn(MetadataColumnDto metadataColumnDto) {
        MetadataColumnEntity metadataColumn = metadataColumnMapper.toEntity(metadataColumnDto);
        metadataColumnDao.insert(metadataColumn);
        return metadataColumn;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MetadataColumnEntity updateMetadataColumn(MetadataColumnDto metadataColumnDto) {
        MetadataColumnEntity metadataColumn = metadataColumnMapper.toEntity(metadataColumnDto);
        metadataColumnDao.updateById(metadataColumn);
        return metadataColumn;
    }

    @Override
    public MetadataColumnEntity getMetadataColumnById(String id) {
        MetadataColumnEntity metadataColumnEntity = super.getById(id);
        return metadataColumnEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteMetadataColumnById(String id) {
        metadataColumnDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteMetadataColumnBatch(List<String> ids) {
        metadataColumnDao.deleteBatchIds(ids);
    }

    @Override
    public List<MetadataTreeVo> getDataMetadataTree(String level) {
        List<MetadataSourceEntity> sourceList = metadataSourceDao.selectList(Wrappers.emptyWrapper());
        List<MetadataTableEntity> tableList = metadataTableDao.selectList(Wrappers.emptyWrapper());
        List<MetadataColumnEntity> columnList = metadataColumnDao.selectList(Wrappers.emptyWrapper());
        List<MetadataTreeVo> list = sourceList.stream().filter(s -> DataConstant.EnableState.ENABLE.getKey().equals(s.getStatus()))
                .map(m -> {
                    MetadataTreeVo tree = new MetadataTreeVo();
                    tree.setId(m.getId());
                    tree.setType(DataLevel.DATABASE.getKey());
                    tree.setLabel(m.getSourceName());
                    if (DataLevel.getLevel(level).getLevel() >= DataLevel.TABLE.getLevel()) {
                        tree.setChildren(getTableChildrens(m.getId(), level, tableList, columnList));
                    }
                    return tree;
                }).collect(Collectors.toList());
        return list;
    }

    private List<MetadataTreeVo> getTableChildrens(String id, String level, List<MetadataTableEntity> tableList, List<MetadataColumnEntity> columnList) {
        List<MetadataTreeVo> children = tableList.stream().filter(m -> Objects.equals(id, m.getSourceId()))
                .map(m -> {
                    MetadataTreeVo tree = new MetadataTreeVo();
                    tree.setId(m.getId());
                    tree.setType(DataLevel.TABLE.getKey());
                    tree.setLabel(StrUtil.isBlank(m.getTableComment()) ? m.getTableName() : m.getTableComment());
                    if (DataLevel.getLevel(level).getLevel() >= DataLevel.COLUMN.getLevel()) {
                        tree.setChildren(getColumnChildrens(m.getId(), columnList));
                    }
                    return tree;
                }).collect(Collectors.toList());
        return children;
    }

    private List<MetadataTreeVo> getColumnChildrens(String id, List<MetadataColumnEntity> columnList) {
        List<MetadataTreeVo> children = columnList.stream().filter(m -> Objects.equals(id, m.getTableId()))
                .map(m -> {
                    MetadataTreeVo tree = new MetadataTreeVo();
                    tree.setId(m.getId());
                    tree.setType(DataLevel.TABLE.getKey());
                    tree.setLabel(StrUtil.isBlank(m.getColumnComment()) ? m.getColumnName() : m.getColumnComment());
                    return tree;
                }).collect(Collectors.toList());
        return children;
    }
}
