package cn.datax.service.system.api.feign.fallback;

import cn.datax.common.core.R;
import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.api.feign.LogServiceFeign;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@AllArgsConstructor
public class LogServiceFeignFallbackImpl implements LogServiceFeign {

    private final Throwable cause;

    @Override
    public R saveLog(LogDto logDto) {
        log.error("feign 调用出错,信息:{}", cause.getLocalizedMessage());
        return null;
    }
}
