package cn.datax.service.data.market.api.mapping.service.impl;

import cn.datax.service.data.market.api.entity.DataApiEntity;
import cn.datax.service.data.market.api.feign.DataApiServiceFeign;
import cn.datax.service.data.market.api.mapping.handler.MappingHandlerMapping;
import cn.datax.service.data.market.api.mapping.service.QueueHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class QueueHandlerServiceImpl implements QueueHandlerService {

    @Autowired
    private DataApiServiceFeign dataApiServiceFeign;

    @Autowired
    private MappingHandlerMapping mappingHandlerMapping;

    @Override
    public void handlerRelease(String id) {
        DataApiEntity dataApiEntity = dataApiServiceFeign.getDataApiById(id);
        if (dataApiEntity != null) {
            mappingHandlerMapping.registerMapping(dataApiEntity);
        }
    }

    @Override
    public void handlerCancel(String id) {
        DataApiEntity dataApiEntity = dataApiServiceFeign.getDataApiById(id);
        if (dataApiEntity != null) {
            mappingHandlerMapping.unregisterMapping(dataApiEntity);
        }
    }
}
