package cn.datax.service.data.metadata.api.vo;

import java.io.Serializable;
import java.util.List;

public class MetadataDatabase implements Serializable {

    private static final long serialVersionUID=1L;

    private String database;
    private List<MetadataTable> tables;

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public List<MetadataTable> getTables() {
        return tables;
    }

    public void setTables(List<MetadataTable> tables) {
        this.tables = tables;
    }

    @Override
    public String toString() {
        return "MetadataDatabase{" +
                "database='" + database + '\'' +
                ", tables=" + tables +
                '}';
    }

    public class MetadataTable implements Serializable {
        private static final long serialVersionUID=1L;

        private String tableName;
        private String tableComment;
        private List<MetadataColumn> columns;

        public String getTableName() {
            return tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getTableComment() {
            return tableComment;
        }

        public void setTableComment(String tableComment) {
            this.tableComment = tableComment;
        }

        public List<MetadataColumn> getColumns() {
            return columns;
        }

        public void setColumns(List<MetadataColumn> columns) {
            this.columns = columns;
        }

        @Override
        public String toString() {
            return "MetadataTable{" +
                    "tableName='" + tableName + '\'' +
                    ", tableComment='" + tableComment + '\'' +
                    ", columns=" + columns +
                    '}';
        }
    }

    public class MetadataColumn implements Serializable {
        private static final long serialVersionUID=1L;

        private String columnPosition;
        private String columnName;
        private String dataType;
        private String dataLength;
        private String dataPrecision;
        private String dataScale;
        private String columnNullable;
        private String columnKey;
        private String dataDefault;
        private String columnComment;

        public String getColumnPosition() {
            return columnPosition;
        }

        public void setColumnPosition(String columnPosition) {
            this.columnPosition = columnPosition;
        }

        public String getColumnName() {
            return columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getDataType() {
            return dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDataLength() {
            return dataLength;
        }

        public void setDataLength(String dataLength) {
            this.dataLength = dataLength;
        }

        public String getDataPrecision() {
            return dataPrecision;
        }

        public void setDataPrecision(String dataPrecision) {
            this.dataPrecision = dataPrecision;
        }

        public String getDataScale() {
            return dataScale;
        }

        public void setDataScale(String dataScale) {
            this.dataScale = dataScale;
        }

        public String getColumnNullable() {
            return columnNullable;
        }

        public void setColumnNullable(String columnNullable) {
            this.columnNullable = columnNullable;
        }

        public String getColumnKey() {
            return columnKey;
        }

        public void setColumnKey(String columnKey) {
            this.columnKey = columnKey;
        }

        public String getDataDefault() {
            return dataDefault;
        }

        public void setDataDefault(String dataDefault) {
            this.dataDefault = dataDefault;
        }

        public String getColumnComment() {
            return columnComment;
        }

        public void setColumnComment(String columnComment) {
            this.columnComment = columnComment;
        }

        @Override
        public String toString() {
            return "MetadataColumn{" +
                    "columnPosition='" + columnPosition + '\'' +
                    ", columnName='" + columnName + '\'' +
                    ", dataType='" + dataType + '\'' +
                    ", dataLength='" + dataLength + '\'' +
                    ", dataPrecision='" + dataPrecision + '\'' +
                    ", dataScale='" + dataScale + '\'' +
                    ", columnNullable='" + columnNullable + '\'' +
                    ", columnKey='" + columnKey + '\'' +
                    ", dataDefault='" + dataDefault + '\'' +
                    ", columnComment='" + columnComment + '\'' +
                    '}';
        }
    }
}
