package cn.datax.common.database.constants;

/**
 * 数据库类型
 *
 * @author yuwei
 * @since 2020-03-14
 */
public enum DbType {

    /**
     * MYSQL
     */
    MYSQL("mysql", "MySql数据库", "jdbc:mysql://${host}:${port}/${dbName}?serverTimezone=GMT%2B8&characterEncoding=UTF-8&useUnicode=true&useSSL=false"),
    /**
     * MARIADB
     */
    MARIADB("mariadb", "MariaDB数据库", "jdbc:mariadb://${host}:${port}/${dbName}"),
    /**
     * ORACLE
     */
    ORACLE("oracle", "Oracle11g及以下数据库", "jdbc:oracle:thin:@${host}:${port}:${dbName}"),
    /**
     * oracle12c new pagination
     */
    ORACLE_12C("oracle12c", "Oracle12c+数据库", "jdbc:oracle:thin:@${host}:${port}:${dbName}"),
    /**
     * POSTGRE
     */
    POSTGRE_SQL("postgresql", "Postgre数据库", "jdbc:postgresql://${host}:${port}/${dbName}"),
    /**
     * SQLSERVER2005
     */
    SQL_SERVER2008("sqlserver2008", "SQLServer2008及以下数据库", "jdbc:sqlserver://${host}:${port};DatabaseName=${dbName}"),
    /**
     * SQLSERVER
     */
    SQL_SERVER("sqlserver", "SQLServer2012+数据库", "jdbc:sqlserver://${host}:${port};DatabaseName=${dbName}"),
    /**
     * UNKONWN DB
     */
    OTHER("other", "其他数据库", "");

    /**
     * 数据库名称
     */
    private final String db;

    /**
     * 描述
     */
    private final String desc;

    /**
     * url
     */
    private final String url;

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getUrl() {
        return this.url;
    }

    DbType(String db, String desc, String url) {
        this.db = db;
        this.desc = desc;
        this.url = url;
    }

    /**
     * 获取数据库类型
     *
     * @param dbType 数据库类型字符串
     */
    public static DbType getDbType(String dbType) {
        for (DbType type : DbType.values()) {
            if (type.db.equalsIgnoreCase(dbType)) {
                return type;
            }
        }
        return OTHER;
    }
}
