package cn.datax.service.email.controller;

import cn.datax.common.core.R;
import cn.datax.common.log.annotation.LogAop;
import cn.datax.service.email.api.entity.EmailEntity;
import cn.datax.service.email.service.EmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/email")
public class EmailController {

    @Autowired
    private EmailService emailService;

    @LogAop(module = "datax-service-email", value = "发送邮件")
    @PostMapping
    public R sendMail(@RequestBody EmailEntity mail) {
        emailService.sendEmail(mail);
        return R.ok();
    }

}
