import request from '@/utils/request'

export function listDataApi (data) {
  return request({
    url: '/data/market/dataApis/list',
    method: 'get',
    params: data
  })
}

export function pageDataApi (data) {
  return request({
    url: '/data/market/dataApis/page',
    method: 'get',
    params: data
  })
}

export function getDataApi (id) {
  return request({
    url: '/data/market/dataApis/' + id,
    method: 'get'
  })
}

export function delDataApi (id) {
  return request({
    url: '/data/market/dataApis/' + id,
    method: 'delete'
  })
}

export function delDataApis (ids) {
  return request({
    url: '/data/market/dataApis/batch/' + ids,
    method: 'delete'
  })
}

export function addDataApi (data) {
  return request({
    url: '/data/market/dataApis',
    method: 'post',
    data: data
  })
}

export function updateDataApi (data) {
  return request({
    url: '/data/market/dataApis/' + data.id,
    method: 'put',
    data: data
  })
}

export function sqlParse (data) {
  return request({
    url: '/data/market/dataApis/sql/parse',
    method: 'post',
    data: data
  })
}

export function copyDataApi (id) {
  return request({
    url: '/data/market/dataApis/' + id + '/copy',
    method: 'post'
  })
}

export function getApiHeader (id) {
  return request({
    url: '/data/market/apis/' + id + '/header',
    method: 'get'
  })
}

export function apiRegister (id) {
  return request({
    url: '/data/market/apis/' + id + '/register',
    method: 'post'
  })
}

export function apiUnRegister (id) {
  return request({
    url: '/data/market/apis/' + id + '/unregister',
    method: 'post'
  })
}

export function getApiCall (url, header, data) {
  return request({
    url: '/data/market/' + url,
    method: 'get',
    headers: header,
    params: data
  })
}

export function postApiCall (url, header, data) {
  return request({
    url: '/data/market/' + url,
    method: 'post',
    headers: header,
    data: data
  })
}
