package cn.datax.service.data.market.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.service.data.market.api.entity.ApiMaskEntity;
import cn.datax.service.data.market.api.entity.DataApiEntity;
import cn.datax.service.data.market.mapstruct.ApiMaskMapper;
import cn.datax.service.data.market.mapstruct.DataApiMapper;
import cn.datax.service.data.market.service.ApiMaskService;
import cn.datax.service.data.market.service.DataApiService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private DataApiService dataApiService;

    @Autowired
    private DataApiMapper dataApiMapper;

    @Autowired
    private ApiMaskService apiMaskService;

    @Autowired
    private ApiMaskMapper apiMaskMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @DataInner
    @GetMapping("/dataApi/{id}")
    public R getDataApiById(@PathVariable String id) {
        DataApiEntity dataApiEntity = dataApiService.getById(id);
        return R.ok().setData(dataApiMapper.toVO(dataApiEntity));
    }

    /**
     * 通过ID查询信息
     *
     * @param apiId
     * @return
     */
    @DataInner
    @GetMapping("/apiMask/{apiId}")
    public R getApiMaskByApiId(@PathVariable String apiId) {
        ApiMaskEntity apiMaskEntity = apiMaskService.getOne(new QueryWrapper<ApiMaskEntity>().eq("api_id", apiId));
        return R.ok().setData(apiMaskMapper.toVO(apiMaskEntity));
    }
}
