package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.DeptDto;
import cn.datax.service.system.service.DeptService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/dept")
public class DeptController extends BaseController {

    @Autowired
    private DeptService deptService;

    @GetMapping("/{id}")
    public R getDeptById(@PathVariable String id) {
        return R.ok().setData(deptService.getById(id));
    }

    @GetMapping("/list")
    public R getDeptList() {
        return R.ok().setData(deptService.list(Wrappers.emptyWrapper()));
    }

    @PostMapping()
    public R saveDept(@RequestBody @Validated({ValidateGroupForSave.class}) DeptDto dept) {
        deptService.saveDept(dept);
        return R.ok();
    }

    @PutMapping()
    public R updateDept(@RequestBody @Validated({ValidateGroupForUpdate.class}) DeptDto dept) {
        deptService.updateDept(dept);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteDept(@PathVariable String id) {
        deptService.deleteDeptById(id);
        return R.ok();
    }

}

