package cn.datax.service.data.factory;

import cn.datax.common.log.annotation.EnableDataLog;
import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableDataLog
@EnableFeignClients(basePackages = {"cn.datax.service.system.api.feign"})
@SpringCloudApplication
public class DataFactoryApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataFactoryApplication.class);
    }
}
