package cn.datax.service.data.factory.api.feign;

import cn.datax.service.data.factory.api.entity.DataSetEntity;
import cn.datax.service.data.factory.api.feign.factory.DataSetServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(contextId = "dataSetServiceFeign", value = "datax-service-data-factory", fallbackFactory = DataSetServiceFeignFallbackFactory.class)
public interface DataSetServiceFeign {

    @GetMapping("/inner/sets/{id}")
    DataSetEntity getDataSetById(@PathVariable("id") String id);
}
