package cn.datax.service.data.factory.api.feign;

import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.api.feign.factory.DataSourceServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;

@FeignClient(contextId = "dataSourceServiceFeign", value = "datax-service-data-factory", fallbackFactory = DataSourceServiceFeignFallbackFactory.class)
public interface DataSourceServiceFeign {

    @GetMapping("/inner/sources/{id}")
    DataSourceEntity getDataSourceById(@PathVariable("id") String id);

    @PutMapping("/inner/sources/sync/{id}")
    void updateDataSourceSyncById(@PathVariable("id") String id);
}
