package cn.datax.service.data.factory.service.impl;

import cn.datax.service.data.factory.api.entity.DataThemeEntity;
import cn.datax.service.data.factory.api.dto.DataThemeDto;
import cn.datax.service.data.factory.service.DataThemeService;
import cn.datax.service.data.factory.mapstruct.DataThemeMapper;
import cn.datax.service.data.factory.dao.DataThemeDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 数据主题信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-07-26
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataThemeServiceImpl extends BaseServiceImpl<DataThemeDao, DataThemeEntity> implements DataThemeService {

    @Autowired
    private DataThemeDao dataThemeDao;

    @Autowired
    private DataThemeMapper dataThemeMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataThemeEntity saveDataTheme(DataThemeDto dataThemeDto) {
        DataThemeEntity dataTheme = dataThemeMapper.toEntity(dataThemeDto);
        dataThemeDao.insert(dataTheme);
        return dataTheme;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataThemeEntity updateDataTheme(DataThemeDto dataThemeDto) {
        DataThemeEntity dataTheme = dataThemeMapper.toEntity(dataThemeDto);
        dataThemeDao.updateById(dataTheme);
        return dataTheme;
    }

    @Override
    public DataThemeEntity getDataThemeById(String id) {
        DataThemeEntity dataThemeEntity = super.getById(id);
        return dataThemeEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataThemeById(String id) {
        dataThemeDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataThemeBatch(List<String> ids) {
        dataThemeDao.deleteBatchIds(ids);
    }
}
