package cn.datax.service.data.market.api.mapping.service.impl;

import cn.datax.common.utils.MD5Util;
import cn.datax.common.utils.SecurityUtil;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.data.market.api.mapping.service.ApiExecuteService;
import cn.datax.service.data.market.api.vo.ApiHeader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ApiExecuteServiceImpl implements ApiExecuteService {

    @Override
    public ApiHeader getApiHeader(String id) {
        try {
            ApiHeader apiHeader = new ApiHeader();
            MD5Util mt = MD5Util.getInstance();
            apiHeader.setApiKey(mt.encode(id));
            apiHeader.setSecretKey(mt.encode(SecurityUtil.getUserId()));
            return apiHeader;
        } catch (Exception e) {
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            return null;
        }
    }
}
