package cn.datax.service.data.metadata.service.impl;

import cn.datax.service.data.metadata.api.entity.DataMetadataColumnEntity;
import cn.datax.service.data.metadata.api.dto.DataMetadataColumnDto;
import cn.datax.service.data.metadata.service.DataMetadataColumnService;
import cn.datax.service.data.metadata.mapstruct.DataMetadataColumnMapper;
import cn.datax.service.data.metadata.dao.DataMetadataColumnDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 元数据信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-07-29
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataMetadataColumnServiceImpl extends BaseServiceImpl<DataMetadataColumnDao, DataMetadataColumnEntity> implements DataMetadataColumnService {

    @Autowired
    private DataMetadataColumnDao dataMetadataColumnDao;

    @Autowired
    private DataMetadataColumnMapper dataMetadataColumnMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataMetadataColumnEntity saveDataMetadataColumn(DataMetadataColumnDto dataMetadataColumnDto) {
        DataMetadataColumnEntity dataMetadataColumn = dataMetadataColumnMapper.toEntity(dataMetadataColumnDto);
        dataMetadataColumnDao.insert(dataMetadataColumn);
        return dataMetadataColumn;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataMetadataColumnEntity updateDataMetadataColumn(DataMetadataColumnDto dataMetadataColumnDto) {
        DataMetadataColumnEntity dataMetadataColumn = dataMetadataColumnMapper.toEntity(dataMetadataColumnDto);
        dataMetadataColumnDao.updateById(dataMetadataColumn);
        return dataMetadataColumn;
    }

    @Override
    public DataMetadataColumnEntity getDataMetadataColumnById(String id) {
        DataMetadataColumnEntity dataMetadataColumnEntity = super.getById(id);
        return dataMetadataColumnEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataMetadataColumnById(String id) {
        dataMetadataColumnDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataMetadataColumnBatch(List<String> ids) {
        dataMetadataColumnDao.deleteBatchIds(ids);
    }
}
