package cn.datax.service.data.metadata.service.impl;

import cn.datax.service.data.metadata.api.entity.DataMetadataTableEntity;
import cn.datax.service.data.metadata.api.dto.DataMetadataTableDto;
import cn.datax.service.data.metadata.service.DataMetadataTableService;
import cn.datax.service.data.metadata.mapstruct.DataMetadataTableMapper;
import cn.datax.service.data.metadata.dao.DataMetadataTableDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 数据库表信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-07-29
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataMetadataTableServiceImpl extends BaseServiceImpl<DataMetadataTableDao, DataMetadataTableEntity> implements DataMetadataTableService {

    @Autowired
    private DataMetadataTableDao dataMetadataTableDao;

    @Autowired
    private DataMetadataTableMapper dataMetadataTableMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataMetadataTableEntity saveDataMetadataTable(DataMetadataTableDto dataMetadataTableDto) {
        DataMetadataTableEntity dataMetadataTable = dataMetadataTableMapper.toEntity(dataMetadataTableDto);
        dataMetadataTableDao.insert(dataMetadataTable);
        return dataMetadataTable;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DataMetadataTableEntity updateDataMetadataTable(DataMetadataTableDto dataMetadataTableDto) {
        DataMetadataTableEntity dataMetadataTable = dataMetadataTableMapper.toEntity(dataMetadataTableDto);
        dataMetadataTableDao.updateById(dataMetadataTable);
        return dataMetadataTable;
    }

    @Override
    public DataMetadataTableEntity getDataMetadataTableById(String id) {
        DataMetadataTableEntity dataMetadataTableEntity = super.getById(id);
        return dataMetadataTableEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataMetadataTableById(String id) {
        dataMetadataTableDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataMetadataTableBatch(List<String> ids) {
        dataMetadataTableDao.deleteBatchIds(ids);
    }
}
