package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.RoleDto;
import cn.datax.service.system.api.entity.RoleEntity;
import cn.datax.service.system.service.RoleService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/role")
public class RoleController extends BaseController {

    @Autowired
    private RoleService roleService;

    /**
     * 通过ID查询角色信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public R getRoleById(@PathVariable String id) {
        return R.ok().setData(roleService.getById(id));
    }

    /**
     *分页查询角色信息
     * @param page current=1&size=20
     * @param role
     * @return
     */
    @GetMapping("/page")
    public R getRolePage(Page page, RoleEntity role) {
        return R.ok().setData(roleService.page(page, Wrappers.query(role)));
    }

    /**
     * 添加角色
     * @param role
     * @return
     */
    @PostMapping()
    public R saveRole(@RequestBody @Validated({ValidateGroupForSave.class}) RoleDto role) {
        roleService.saveRole(role);
        return R.ok();
    }

    /**
     * 修改角色
     * @param role
     * @return
     */
    @PutMapping()
    public R updateRole(@RequestBody @Validated({ValidateGroupForUpdate.class}) RoleDto role) {
        roleService.updateRole(role);
        return R.ok();
    }

    /**
     * 删除角色
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public R deleteRole(@PathVariable String id) {
        roleService.deleteRoleById(id);
        return R.ok();
    }

}

