package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.UserDto;
import cn.datax.service.system.api.entity.UserEntity;
import cn.datax.service.system.mapstruct.UserMapper;
import cn.datax.service.system.service.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.security.Principal;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/user")
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private UserMapper userMapper;

    @GetMapping("/token")
    public Principal tokenUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication;
    }

    @GetMapping("/{id}")
    public R getUserById(@PathVariable String id) {
        UserEntity userEntity = userService.getById(id);
        return R.ok().setData(userMapper.toVO(userEntity));
    }

    @GetMapping("/page")
    public R getUserPage(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum,
                         @RequestParam(value="pageSize", defaultValue="20") Integer pageSize,
                         UserDto user) {
        QueryWrapper<UserEntity> queryWrapper = Wrappers.emptyWrapper();
        IPage<UserEntity> page = userService.page(new Page<>(pageNum, pageSize), queryWrapper);
        page.getRecords().stream().map(userMapper::toVO);
        return R.ok().setData(page);
    }

    @PostMapping()
    public R saveUser(@RequestBody @Validated({ValidateGroupForSave.class}) UserDto user) {
        userService.saveUser(user);
        return R.ok();
    }

    @PutMapping()
    public R updateUser(@RequestBody @Validated({ValidateGroupForUpdate.class}) UserDto user) {
        userService.updateUser(user);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteUser(@PathVariable String id) {
        userService.deleteUserById(id);
        return R.ok();
    }

}

