package cn.datax.service.system.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.service.system.api.entity.LogEntity;
import cn.datax.service.system.api.query.LogQuery;
import cn.datax.service.system.api.vo.LogVo;
import cn.datax.service.system.mapstruct.LogMapper;
import cn.datax.service.system.service.LogService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@Api(value="系统管理接口", tags = {"系统管理"})
@RestController
@RequestMapping("/logs")
public class LogController extends BaseController {

    @Autowired
    private LogService logService;

    @Autowired
    private LogMapper logMapper;

    @ApiOperation(value = "日志分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "logQuery", value = "查询实体logQuery", required = true, dataTypeClass = LogQuery.class)
    })
    @GetMapping("/page")
    public R getLogPage(LogQuery logQuery) {
        QueryWrapper<LogEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StrUtil.isNotBlank(logQuery.getTitle()), "title", logQuery.getTitle());
        IPage<LogEntity> page = logService.page(new Page<>(logQuery.getPageNum(), logQuery.getPageSize()), queryWrapper);
        List<LogVo> collect = page.getRecords().stream().map(logMapper::toVO).collect(Collectors.toList());
        JsonPage<LogVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }
}
