package cn.datax.common.log.async;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class AsyncTask {
	
	@Async("dataLogExecutor")
    public void doTask() {
		log.info("开始做任务--模拟日志");
        long start = System.currentTimeMillis();
        try {
			Thread.sleep(1000);
		} catch (Exception e) {
			e.printStackTrace();
		}
        long end = System.currentTimeMillis();
        log.info("完成任务，耗时：" + (end - start) + "毫秒");
    }

}