package cn.datax.service.workflow.service.impl;

import cn.datax.service.workflow.api.enums.VariablesEnum;
import cn.datax.service.workflow.api.query.FlowTaskQuery;
import cn.datax.service.workflow.service.FlowTaskService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class FlowTaskServiceImpl implements FlowTaskService {

    @Autowired
    private TaskService taskService;

    @Autowired
    private HistoryService historyService;

    @Override
    public void pageTodo(FlowTaskQuery flowTaskQuery) {
        TaskQuery taskQuery = taskService.createTaskQuery();
        taskQuery.taskCandidateOrAssigned(flowTaskQuery.getUserId()).taskCandidateGroupIn(flowTaskQuery.getGroupIds());
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessKey())){
            taskQuery.processInstanceBusinessKey(flowTaskQuery.getBusinessKey());
        }
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessType())){
            taskQuery.processVariableValueEquals(VariablesEnum.businessType.toString(), flowTaskQuery.getBusinessType());
        }
        if(StrUtil.isNotBlank(flowTaskQuery.getBusinessName())){
            taskQuery.processVariableValueLike(VariablesEnum.businessName.toString(), flowTaskQuery.getBusinessName());
        }
        List<Task> taskList = taskQuery.includeProcessVariables()
                .orderByTaskPriority().desc()
                .orderByTaskCreateTime().desc()
                .listPage((flowTaskQuery.getPageNum() - 1) * flowTaskQuery.getPageSize(), flowTaskQuery.getPageSize());
        taskList.stream().forEach(task -> {
            System.out.println(task);
            System.out.println(task.getProcessVariables());
            System.out.println("-----------------");
        });
        long count = taskQuery.count();
        Page<Task> page = new Page<>(flowTaskQuery.getPageNum(), flowTaskQuery.getPageSize());
        page.setRecords(taskList);
        page.setTotal(count);
    }

    @Override
    public void pageDone(FlowTaskQuery flowTaskQuery) {
        HistoricTaskInstanceQuery historicTaskInstanceQuery = historyService.createHistoricTaskInstanceQuery();
        historicTaskInstanceQuery.taskAssignee(flowTaskQuery.getUserId());
        if (StringUtils.isNotBlank(flowTaskQuery.getBusinessKey())) {
            historicTaskInstanceQuery.processInstanceBusinessKey(flowTaskQuery.getBusinessKey());
        }
        if (StringUtils.isNotBlank(flowTaskQuery.getBusinessName())) {
            historicTaskInstanceQuery.processVariableValueEquals(VariablesEnum.businessType.toString(), flowTaskQuery.getBusinessName());
        }
        if (StringUtils.isNotBlank(flowTaskQuery.getBusinessType())) {
            historicTaskInstanceQuery.processVariableValueLike(VariablesEnum.businessName.toString(), flowTaskQuery.getBusinessType());
        }
        List<HistoricTaskInstance> historicTaskInstanceList = historicTaskInstanceQuery.finished()
                .includeProcessVariables().orderByHistoricTaskInstanceEndTime().desc()
                .listPage((flowTaskQuery.getPageNum() - 1) * flowTaskQuery.getPageSize(), flowTaskQuery.getPageSize());
        historicTaskInstanceList.stream().forEach(task -> {
            System.out.println(task);
            System.out.println(task.getProcessVariables());
            System.out.println("-----------------");
        });
        long count = historicTaskInstanceQuery.count();
        Page<HistoricTaskInstance> page = new Page<>(flowTaskQuery.getPageNum(), flowTaskQuery.getPageSize());
        page.setRecords(historicTaskInstanceList);
        page.setTotal(count);
    }
}
