import request from '@/utils/request'

export function pageInstance(data) {
  return request({
    url: '/workflow/instances/page',
    method: 'get',
    params: data
  })
}

export function delInstance(processInstanceId) {
  return request({
    url: '/workflow/instances/delete/' + processInstanceId,
    method: 'delete'
  })
}

export function activateInstance(processInstanceId) {
  return request({
    url: '/workflow/instances/activate/' + processInstanceId,
    method: 'put'
  })
}

export function suspendInstance(processInstanceId) {
  return request({
    url: '/workflow/instances/suspend/' + processInstanceId,
    method: 'put'
  })
}
