package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.UserDto;
import cn.datax.service.system.api.entity.UserEntity;
import cn.datax.service.system.service.UserService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.security.Principal;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/user")
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @GetMapping("/token")
    public Principal tokenUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication;
    }

    @GetMapping("/{id}")
    public R getUserById(@PathVariable String id) {
        return R.ok().setData(userService.getById(id));
    }

    @GetMapping("/page")
    public R getUserPage(Page page, UserEntity user) {
        return R.ok().setData(userService.page(page, Wrappers.query(user)));
    }

    @PostMapping()
    public R saveUser(@RequestBody @Validated({ValidateGroupForSave.class}) UserDto user) {
        userService.saveUser(user);
        return R.ok();
    }

    @PutMapping()
    public R updateUser(@RequestBody @Validated({ValidateGroupForUpdate.class}) UserDto user) {
        userService.updateUser(user);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteUser(@PathVariable String id) {
        userService.deleteUserById(id);
        return R.ok();
    }

}

