package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.dto.MenuDto;
import cn.datax.service.system.api.entity.MenuEntity;
import cn.datax.service.system.mapper.MenuMapper;
import cn.datax.service.system.service.MenuService;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class MenuServiceImpl extends BaseServiceImpl<MenuMapper, MenuEntity> implements MenuService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMenu(MenuDto menuDto) {
        MenuEntity menu = new MenuEntity();
        BeanUtils.copyProperties(menuDto, menu);
        baseMapper.insert(menu);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMenu(MenuDto menuDto) {
        MenuEntity menu = new MenuEntity();
        BeanUtils.copyProperties(menuDto, menu);
        baseMapper.updateById(menu);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteMenuById(String id) {
        baseMapper.deleteById(id);
    }
}
