package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.dto.UserDto;
import cn.datax.service.system.api.entity.UserDeptEntity;
import cn.datax.service.system.api.entity.UserEntity;
import cn.datax.service.system.api.entity.UserPostEntity;
import cn.datax.service.system.api.entity.UserRoleEntity;
import cn.datax.service.system.mapper.UserDeptMapper;
import cn.datax.service.system.mapper.UserMapper;
import cn.datax.service.system.mapper.UserPostMapper;
import cn.datax.service.system.mapper.UserRoleMapper;
import cn.datax.service.system.service.UserService;
import cn.datax.common.base.BaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class UserServiceImpl extends BaseServiceImpl<UserMapper, UserEntity> implements UserService {

    @Autowired
    private UserDeptMapper userDeptMapper;
    @Autowired
    private UserPostMapper userPostMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveUser(UserDto userDto) {
        UserEntity user = new UserEntity();
        BeanUtils.copyProperties(userDto, user);
        baseMapper.insert(user);
        insertBatchRole(userDto, user);
        insertBatchDept(userDto, user);
        insertBatchPost(userDto, user);
    }

    private void insertBatchPost(UserDto userDto, UserEntity user) {
        List<UserPostEntity> userPostList = userDto.getPosts()
                .stream().map(postId -> {
                    UserPostEntity userPost = new UserPostEntity();
                    userPost.setUserId(user.getId());
                    userPost.setPostId(postId);
                    return userPost;
                }).collect(Collectors.toList());
        userPostMapper.insertBatch(userPostList);
    }

    private void insertBatchDept(UserDto userDto, UserEntity user) {
        List<UserDeptEntity> userDeptList = userDto.getDepts()
                .stream().map(deptId -> {
                    UserDeptEntity userDept = new UserDeptEntity();
                    userDept.setUserId(user.getId());
                    userDept.setDeptId(deptId);
                    return userDept;
                }).collect(Collectors.toList());
        userDeptMapper.insertBatch(userDeptList);
    }

    private void insertBatchRole(UserDto userDto, UserEntity user) {
        List<UserRoleEntity> userRoleList = userDto.getRoles()
                .stream().map(roleId -> {
                    UserRoleEntity userRole = new UserRoleEntity();
                    userRole.setUserId(user.getId());
                    userRole.setRoleId(roleId);
                    return userRole;
                }).collect(Collectors.toList());
        userRoleMapper.insertBatch(userRoleList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateUser(UserDto userDto) {
        UserEntity user = new UserEntity();
        BeanUtils.copyProperties(userDto, user);
        baseMapper.updateById(user);
        userRoleMapper.delete(Wrappers.<UserRoleEntity>lambdaQuery()
                .eq(UserRoleEntity::getUserId, userDto.getId()));
        insertBatchRole(userDto, user);
        userDeptMapper.delete(Wrappers.<UserDeptEntity>lambdaQuery()
                .eq(UserDeptEntity::getUserId, userDto.getId()));
        insertBatchDept(userDto, user);
        userPostMapper.delete(Wrappers.<UserPostEntity>lambdaQuery()
                .eq(UserPostEntity::getUserId, userDto.getId()));
        insertBatchPost(userDto, user);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteUserById(String id) {
        baseMapper.deleteById(id);
    }

}
