import request from '@/utils/request'

export function pageConfig (data) {
  return request({
    url: '/system/configs/page',
    method: 'get',
    params: data
  })
}

export function getConfig (id) {
  return request({
    url: '/system/configs/' + id,
    method: 'get'
  })
}

export function delConfig (id) {
  return request({
    url: '/system/configs/' + id,
    method: 'delete'
  })
}

export function delConfigs (ids) {
  return request({
    url: '/system/configs/batch/' + ids,
    method: 'delete'
  })
}

export function addConfig (data) {
  return request({
    url: '/system/configs',
    method: 'post',
    data: data
  })
}

export function updateConfig (data) {
  return request({
    url: '/system/configs/' + data.id,
    method: 'put',
    data: data
  })
}
