import storage from '@/utils/storage'

const state = {
  sidebar: {
    opened: storage.ss.get('vue_template_sidebar_status') ? !!+storage.ss.get('vue_template_sidebar_status') : true,
    withoutAnimation: false
  },
  device: 'desktop',
  size: storage.ss.get('vue_template_size') || 'medium'
}

const mutations = {
  TOGGLE_SIDEBAR: state => {
    state.sidebar.opened = !state.sidebar.opened
    state.sidebar.withoutAnimation = false
    if (state.sidebar.opened) {
      storage.ss.set('vue_template_sidebar_status', 1)
    } else {
      storage.ss.set('vue_template_sidebar_status', 0)
    }
  },
  CLOSE_SIDEBAR: (state, withoutAnimation) => {
    storage.ss.set('vue_template_sidebar_status', 0)
    state.sidebar.opened = false
    state.sidebar.withoutAnimation = withoutAnimation
  },
  TOGGLE_DEVICE: (state, device) => {
    state.device = device
  },
  SET_SIZE: (state, size) => {
    state.size = size
    storage.ss.set('vue_template_size', size)
  }
}

const actions = {
  toggleSideBar ({ commit }) {
    commit('TOGGLE_SIDEBAR')
  },
  closeSideBar ({ commit }, { withoutAnimation }) {
    commit('CLOSE_SIDEBAR', withoutAnimation)
  },
  toggleDevice ({ commit }, device) {
    commit('TOGGLE_DEVICE', device)
  },
  setSize ({ commit }, size) {
    commit('SET_SIZE', size)
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
