package cn.datax.service.data.standard.service.impl;

import cn.datax.service.data.standard.api.entity.StandardTypeEntity;
import cn.datax.service.data.standard.api.dto.StandardTypeDto;
import cn.datax.service.data.standard.service.StandardTypeService;
import cn.datax.service.data.standard.mapstruct.StandardTypeMapper;
import cn.datax.service.data.standard.dao.StandardTypeDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 标准类别信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-08-10
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class StandardTypeServiceImpl extends BaseServiceImpl<StandardTypeDao, StandardTypeEntity> implements StandardTypeService {

    @Autowired
    private StandardTypeDao standardTypeDao;

    @Autowired
    private StandardTypeMapper standardTypeMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardTypeEntity saveStandardType(StandardTypeDto standardTypeDto) {
        StandardTypeEntity standardType = standardTypeMapper.toEntity(standardTypeDto);
        standardTypeDao.insert(standardType);
        return standardType;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardTypeEntity updateStandardType(StandardTypeDto standardTypeDto) {
        StandardTypeEntity standardType = standardTypeMapper.toEntity(standardTypeDto);
        standardTypeDao.updateById(standardType);
        return standardType;
    }

    @Override
    public StandardTypeEntity getStandardTypeById(String id) {
        StandardTypeEntity standardTypeEntity = super.getById(id);
        return standardTypeEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteStandardTypeById(String id) {
        standardTypeDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteStandardTypeBatch(List<String> ids) {
        standardTypeDao.deleteBatchIds(ids);
    }
}
