package cn.datax.auth;

import cn.datax.common.mybatis.annotation.EnableDataMybatis;
import cn.datax.common.redis.annotation.EnableDataRedis;
import cn.datax.common.security.annotation.EnableDataAuthExceptionHandler;
import cn.datax.common.security.annotation.EnableDataServerProtect;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

@EnableDataAuthExceptionHandler
@EnableDataServerProtect
@EnableDataMybatis
@EnableDataRedis
@EnableFeignClients(basePackages = {"cn.datax.service.system.api.feign"})
@ComponentScan(basePackages = {"cn.datax"})
@SpringCloudApplication
public class DataxAuthApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataxAuthApplication.class, args);
    }

}
