package cn.datax.auth.service;

import cn.datax.common.core.R;
import cn.datax.service.system.api.entity.UserEntity;
import cn.datax.service.system.api.feign.UserServiceFeign;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Set;

@Slf4j
@Service
public class DataUserDetailService implements UserDetailsService {

    @Autowired
    private UserServiceFeign userServiceFeign;

    @Override
    public UserDetails loadUserByUsername(String s) throws UsernameNotFoundException {
        //远程获取用户
        R result = userServiceFeign.getUserByUsername(s);
        log.info(JSON.toJSONString(result));
        if (!StrUtil.equals("admin", s)) {
            throw new UsernameNotFoundException(StrUtil.format("{}用户不存在", s));
        }

//        if(result == null || result.getData() == null){
//            throw new UsernameNotFoundException(StrUtil.format("{}用户不存在", s));
//        }
//        UserEntity userEntity = (UserEntity) result.getData();
        Set<GrantedAuthority> grantedAuthorities = new HashSet<>();
        // 可用性 :true:可用 false:不可用
        boolean enabled = true;
        // 过期性 :true:没过期 false:过期
        boolean accountNonExpired = true;
        // 有效性 :true:凭证有效 false:凭证无效
        boolean credentialsNonExpired = true;
        // 锁定性 :true:未锁定 false:已锁定
        boolean accountNonLocked = true;
//        for (Role role : member.getRoles()) {
//            //角色必须是ROLE_开头，可以在数据库中设置
//            GrantedAuthority grantedAuthority = new SimpleGrantedAuthority(role.getRoleName());
//            grantedAuthorities.add(grantedAuthority);
//            //获取权限
//            for (Permission permission : role.getPermissions()) {
//                GrantedAuthority authority = new SimpleGrantedAuthority(permission.getUri());
//                grantedAuthorities.add(authority);
//            }
//        }
//        userRoleDao.selectAll(new UserRole().setUsername(username))
//                .stream()
//                .map(userRole -> new SimpleGrantedAuthority(userRole.getRole()))
//                .collect(Collectors.toList());
        String encode = new BCryptPasswordEncoder().encode("123456");
        //123456   "$2a$10$3rV8TA7XlfVkZrP0kA0t7OqKoQa93Mw/VZii6nP62pqiD.AjKSUja"
        User user = new User("admin", encode,
                enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, grantedAuthorities);
//        new DataUserDetail(null, grantedAuthorities);
        return user;
    }
}
