package cn.datax.service.file.config;

import java.io.File;

import cn.datax.service.file.properties.FileServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 本地文件配置
 */
@Configuration
@ConditionalOnProperty(name = "data.file-server.type", havingValue = "local")
public class LocalFileAutoConfig {

	@Autowired
	private FileServerProperties fileProperties;

	@Bean
	public WebMvcConfigurer webMvcConfigurerAdapter() {
		return new WebMvcConfigurer() {
			/**
			 * 外部文件访问
			 */
			@Override
			public void addResourceHandlers(ResourceHandlerRegistry registry) {
				registry.addResourceHandler(fileProperties.getLocal().getPrefix() + "/**")
						.addResourceLocations(ResourceUtils.FILE_URL_PREFIX + fileProperties.getLocal().getPath() + File.separator);
			}

		};
	}
}
