package cn.datax.service.data.quality.api.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 核查规则信息表 实体VO
 * </p>
 *
 * @author yuwei
 * @since 2020-09-27
 */
@Data
public class CheckRuleVo implements Serializable {

    private static final long serialVersionUID=1L;

    private String id;
    private String status;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private String ruleName;
    private String ruleTypeId;
    private String ruleLevel;
    private String ruleSourceId;
    private String ruleSource;
    private String ruleTableId;
    private String ruleTable;
    private String ruleColumnId;
    private String ruleColumn;
    private String ruleSql;
}
