package cn.datax.service.data.market.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 服务集成表 实体DTO
 * </p>
 *
 * @author yuwei
 * @since 2020-08-20
 */
@ApiModel(value = "服务集成表Model")
@Data
public class ServiceIntegrationDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键ID")
    @NotBlank(message = "主键ID不能为空", groups = {ValidationGroups.Update.class})
    private String id;
    @ApiModelProperty(value = "服务名称")
    @NotBlank(message = "服务名称不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String serviceName;
    @ApiModelProperty(value = "服务类型（1http接口，2webservice接口）")
    private String serviceType;
    @ApiModelProperty(value = "服务请求地址")
    private String serviceUrl;
    @ApiModelProperty(value = "服务请求头")
    private String serviceHeader;
    @ApiModelProperty(value = "服务请求参数")
    private String serviceParam;
    @ApiModelProperty(value = "服务请求方式")
    private String serviceHttpMethod;
    @ApiModelProperty(value = "服务wsdl地址")
    private String serviceWsdl;
    @ApiModelProperty(value = "服务命名空间")
    private String serviceTargetNamespace;
    @ApiModelProperty(value = "服务请求报文")
    private String serviceSoap;
    @ApiModelProperty(value = "服务方法")
    private String serviceMethod;
    @ApiModelProperty(value = "状态")
    @NotNull(message = "状态不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String status;
    @ApiModelProperty(value = "备注")
    private String remark;
}
