package cn.datax.service.data.market.api.entity;

import cn.datax.common.base.DataScopeBaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 服务集成表
 * </p>
 *
 * @author yuwei
 * @since 2020-08-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("market_service_integration")
public class ServiceIntegrationEntity extends DataScopeBaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 服务编号
     */
    private String serviceNo;

    /**
     * 服务名称
     */
    private String serviceName;

    /**
     * 服务类型（1http接口，2webservice接口）
     */
    private String serviceType;

    /**
     * 服务请求地址
     */
    private String serviceUrl;

    /**
     * 服务请求头
     */
    private String serviceHeader;

    /**
     * 服务请求参数
     */
    private String serviceParam;

    /**
     * 服务请求方式
     */
    private String serviceHttpMethod;

    /**
     * 服务wsdl地址
     */
    private String serviceWsdl;

    /**
     * 服务命名空间
     */
    private String serviceTargetNamespace;

    /**
     * 服务请求报文
     */
    private String serviceSoap;

    /**
     * 服务方法
     */
    private String serviceMethod;
}
