package cn.datax.service.data.standard.service.impl;

import cn.datax.service.data.standard.api.entity.StandardDictEntity;
import cn.datax.service.data.standard.api.dto.StandardDictDto;
import cn.datax.service.data.standard.service.StandardDictService;
import cn.datax.service.data.standard.mapstruct.StandardDictMapper;
import cn.datax.service.data.standard.dao.StandardDictDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 标准信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-08-10
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class StandardDictServiceImpl extends BaseServiceImpl<StandardDictDao, StandardDictEntity> implements StandardDictService {

    @Autowired
    private StandardDictDao standardDictDao;

    @Autowired
    private StandardDictMapper standardDictMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardDictEntity saveStandardDict(StandardDictDto standardDictDto) {
        StandardDictEntity standardDict = standardDictMapper.toEntity(standardDictDto);
        standardDictDao.insert(standardDict);
        return standardDict;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardDictEntity updateStandardDict(StandardDictDto standardDictDto) {
        StandardDictEntity standardDict = standardDictMapper.toEntity(standardDictDto);
        standardDictDao.updateById(standardDict);
        return standardDict;
    }

    @Override
    public StandardDictEntity getStandardDictById(String id) {
        StandardDictEntity standardDictEntity = super.getById(id);
        return standardDictEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteStandardDictById(String id) {
        standardDictDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteStandardDictBatch(List<String> ids) {
        standardDictDao.deleteBatchIds(ids);
    }
}
