package cn.datax.service.data.factory.service.impl;

import cn.datax.common.core.R;
import cn.datax.service.data.factory.api.dto.DataSourceDto;
import cn.datax.service.data.factory.api.entity.DataSchema;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.dao.DataSourceDao;
import cn.datax.service.data.factory.service.DataSourceService;
import cn.datax.service.data.factory.mapstruct.DataSourceMapper;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 数据源信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-03-14
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataSourceServiceImpl extends BaseServiceImpl<DataSourceDao, DataSourceEntity> implements DataSourceService {

    @Autowired
    private DataSourceDao dataSourceDao;

    @Autowired
    private DataSourceMapper dataSourceMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataSource(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        dataSourceDao.insert(dataSource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDataSource(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        dataSourceDao.updateById(dataSource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataSourceById(String id) {
        dataSourceDao.deleteById(id);
    }

    @Override
    public R checkConnection(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        DataSchema sourceSchema = dataSource.getSourceSchema();
        sourceSchema.viald();
        return null;
    }
}
