package cn.datax.service.system.api.dto;

import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class MenuDto implements Serializable {

    private static final long serialVersionUID=1L;

    @NotBlank(message = "主键ID不能为空", groups = {ValidateGroupForUpdate.class})
    private String id;

    @NotBlank(message = "父资源ID不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String parentId;

    @NotBlank(message = "资源名称不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String menuName;

    private String menuPath;

    private String menuComponent;

    private String menuPerms;

    private String menuIcon;

    @NotNull(message = "类型不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private Integer menuType;

    @NotNull(message = "排序不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private Integer menuSort;
}
