package cn.datax.service.system.service.impl;

import cn.datax.common.exception.DataException;
import cn.datax.service.system.api.dto.DeptDto;
import cn.datax.service.system.api.entity.DeptEntity;
import cn.datax.service.system.dao.DeptDao;
import cn.datax.service.system.mapstruct.DeptMapper;
import cn.datax.service.system.service.DeptService;
import cn.datax.common.base.BaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DeptServiceImpl extends BaseServiceImpl<DeptDao, DeptEntity> implements DeptService {

    @Autowired
    private DeptMapper deptMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDept(DeptDto deptDto) {
        DeptEntity dept = deptMapper.toEntity(deptDto);
        baseMapper.insert(dept);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDept(DeptDto deptDto) {
        DeptEntity dept = deptMapper.toEntity(deptDto);
        baseMapper.updateById(dept);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDeptById(String id) {
        int n = baseMapper.selectCount(Wrappers.<DeptEntity>lambdaQuery().eq(DeptEntity::getParentId, id));
        if(n > 0){
            throw new DataException("该部门下存在子部门数据");
        }
        baseMapper.deleteById(id);
    }
}
