package cn.datax.common.security.config;

import cn.datax.common.security.annotation.DataInner;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

/**
 * 服务间接口不鉴权处理逻辑
 *
 * @author yuwei
 * @since 2019/10/30
 */
@Slf4j
@Aspect
@Component
public class DataSecurityInnerAspect {

    @SneakyThrows
    @Around("@annotation(dataInner)")
    public Object around(ProceedingJoinPoint point, DataInner dataInner) {
        log.info("feign内部接口访问 {} 不鉴权处理", point.getSignature().getName());
        return point.proceed();
    }
}
