package cn.datax.service.data.metadata.controller;

import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.validate.ValidationGroups;
import cn.datax.service.data.metadata.api.dto.DataMetadataColumnDto;
import cn.datax.service.data.metadata.api.entity.DataMetadataColumnEntity;
import cn.datax.service.data.metadata.api.vo.DataMetadataColumnVo;
import cn.datax.service.data.metadata.api.query.DataMetadataColumnQuery;
import cn.datax.service.data.metadata.mapstruct.DataMetadataColumnMapper;
import cn.datax.service.data.metadata.service.DataMetadataColumnService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 元数据信息表 前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2020-07-29
 */
@Api(tags = {"元数据信息表"})
@RestController
@RequestMapping("/columns")
public class DataMetadataColumnController extends BaseController {

    @Autowired
    private DataMetadataColumnService dataMetadataColumnService;

    @Autowired
    private DataMetadataColumnMapper dataMetadataColumnMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取详细信息", notes = "根据url的id来获取详细信息")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @GetMapping("/{id}")
    public R getDataMetadataColumnById(@PathVariable String id) {
        DataMetadataColumnEntity dataMetadataColumnEntity = dataMetadataColumnService.getDataMetadataColumnById(id);
        return R.ok().setData(dataMetadataColumnMapper.toVO(dataMetadataColumnEntity));
    }

    @ApiOperation(value = "获取列表", notes = "")
    @GetMapping("/list")
    public R getDataMetadataColumnList(DataMetadataColumnQuery dataMetadataColumnQuery) {
        QueryWrapper<DataMetadataColumnEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StrUtil.isNotBlank(dataMetadataColumnQuery.getColumnName()), "column_name", dataMetadataColumnQuery.getColumnName());
        queryWrapper.eq(StrUtil.isNotBlank(dataMetadataColumnQuery.getSourceId()), "source_id", dataMetadataColumnQuery.getSourceId());
        queryWrapper.eq(StrUtil.isNotBlank(dataMetadataColumnQuery.getTableId()), "table_id", dataMetadataColumnQuery.getTableId());
        List<DataMetadataColumnEntity> list = dataMetadataColumnService.list(queryWrapper);
        List<DataMetadataColumnVo> collect = list.stream().map(dataMetadataColumnMapper::toVO).collect(Collectors.toList());
        return R.ok().setData(collect);
    }

    /**
     * 分页查询信息
     *
     * @param dataMetadataColumnQuery
     * @return
     */
    @ApiOperation(value = "分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dataMetadataColumnQuery", value = "查询实体dataMetadataColumnQuery", required = true, dataTypeClass = DataMetadataColumnQuery.class)
    })
    @GetMapping("/page")
    public R getDataMetadataColumnPage(DataMetadataColumnQuery dataMetadataColumnQuery) {
        QueryWrapper<DataMetadataColumnEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StrUtil.isNotBlank(dataMetadataColumnQuery.getColumnName()), "column_name", dataMetadataColumnQuery.getColumnName());
        queryWrapper.eq(StrUtil.isNotBlank(dataMetadataColumnQuery.getSourceId()), "source_id", dataMetadataColumnQuery.getSourceId());
        queryWrapper.eq(StrUtil.isNotBlank(dataMetadataColumnQuery.getTableId()), "table_id", dataMetadataColumnQuery.getTableId());
        IPage<DataMetadataColumnEntity> page = dataMetadataColumnService.page(new Page<>(dataMetadataColumnQuery.getPageNum(), dataMetadataColumnQuery.getPageSize()), queryWrapper);
        List<DataMetadataColumnVo> collect = page.getRecords().stream().map(dataMetadataColumnMapper::toVO).collect(Collectors.toList());
        JsonPage<DataMetadataColumnVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }

    /**
     * 添加
     * @param dataMetadataColumn
     * @return
     */
    @ApiOperation(value = "添加信息", notes = "根据dataMetadataColumn对象添加信息")
    @ApiImplicitParam(name = "dataMetadataColumn", value = "详细实体dataMetadataColumn", required = true, dataType = "DataMetadataColumnDto")
    @PostMapping()
    public R saveDataMetadataColumn(@RequestBody @Validated({ValidationGroups.Insert.class}) DataMetadataColumnDto dataMetadataColumn) {
        DataMetadataColumnEntity dataMetadataColumnEntity = dataMetadataColumnService.saveDataMetadataColumn(dataMetadataColumn);
        return R.ok().setData(dataMetadataColumnMapper.toVO(dataMetadataColumnEntity));
    }

    /**
     * 修改
     * @param dataMetadataColumn
     * @return
     */
    @ApiOperation(value = "修改信息", notes = "根据url的id来指定修改对象，并根据传过来的信息来修改详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path"),
            @ApiImplicitParam(name = "dataMetadataColumn", value = "详细实体dataMetadataColumn", required = true, dataType = "DataMetadataColumnDto")
    })
    @PutMapping("/{id}")
    public R updateDataMetadataColumn(@PathVariable String id, @RequestBody @Validated({ValidationGroups.Update.class}) DataMetadataColumnDto dataMetadataColumn) {
        DataMetadataColumnEntity dataMetadataColumnEntity = dataMetadataColumnService.updateDataMetadataColumn(dataMetadataColumn);
        return R.ok().setData(dataMetadataColumnMapper.toVO(dataMetadataColumnEntity));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @ApiOperation(value = "删除", notes = "根据url的id来指定删除对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @DeleteMapping("/{id}")
    public R deleteDataMetadataColumnById(@PathVariable String id) {
        dataMetadataColumnService.deleteDataMetadataColumnById(id);
        return R.ok();
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除角色", notes = "根据url的ids来批量删除对象")
    @ApiImplicitParam(name = "ids", value = "ID集合", required = true, dataType = "List", paramType = "path")
    @DeleteMapping("/batch/{ids}")
    public R deleteDataMetadataColumnBatch(@PathVariable List<String> ids) {
        dataMetadataColumnService.deleteDataMetadataColumnBatch(ids);
        return R.ok();
    }
}
