package cn.datax.service.quartz.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;

@Configuration
public class QuartzConfig {

    @Bean
    @QuartzDataSource
    @ConfigurationProperties(prefix = "spring.quartz.properties.org.quartz.datasource")
    DataSource quartzDataSource(){
        // 创建 HikariDataSource 对象
        HikariDataSource dataSource =  new DataSourceProperties().initializeDataSourceBuilder().type(HikariDataSource.class).build();
        // 设置线程池名
        dataSource.setPoolName("QuartzHikariCP");
        return dataSource;
    }
}
